<?php
include('../../../_core/_includes/config.php');
header('Content-Type: application/json');

// Verifica se a requisição é POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['erro' => 'Método não permitido']);
    exit;
}

$url = $_POST['url'] ?? '';
$tipo = $_POST['tipo'] ?? '';

if (empty($url) {
    echo json_encode(['erro' => 'URL não fornecida']);
    exit;
}

// Simulação de extração de dados - substitua por chamadas reais às APIs
try {
    if ($tipo === 'mercadolivre') {
        // Extrai ID do produto do Mercado Livre
        preg_match('/MLB-\d+/', $url, $matches);
        $productId = $matches[0] ?? 'MLB-' . rand(100000000, 999999999);
        
        $produto = [
            'nome' => "Produto Mercado Livre {$productId}",
            'descricao' => "Descrição detalhada do produto {$productId} importado do Mercado Livre. Cor: Preto. Material: Algodão. Garantia: 3 meses.",
            'valor' => number_format(rand(5000, 20000) / 100, // Valor entre 50.00 e 200.00
            'estoque' => '1', // Não controla estoque por padrão
            'posicao' => '0', // Quantidade em estoque
            'video_link' => '',
            'ref' => $productId,
            'oferta' => '2', // Não está em oferta por padrão
            'valor_promocional' => '0.00',
            'imagens' => ['https://http2.mlstatic.com/D_NQ_NP_123456-MLB123456789_012019-O.jpg']
        ];
        
    } elseif ($tipo === 'shopee') {
        // Extrai ID do produto da Shopee
        preg_match('/product\/\d+\/\d+/', $url, $matches);
        $productId = $matches[0] ?? 'shopee-' . rand(100000, 999999);
        
        $produto = [
            'nome' => "Produto Shopee {$productId}",
            'descricao' => "Descrição detalhada do produto {$productId} importado da Shopee. Modelo: 2023. Garantia: 1 ano. Material: Plástico.",
            'valor' => number_format(rand(1000, 10000) / 100, // Valor entre 10.00 e 100.00
            'estoque' => '1', // Não controla estoque por padrão
            'posicao' => '0', // Quantidade em estoque
            'video_link' => '',
            'ref' => $productId,
            'oferta' => '2', // Não está em oferta por padrão
            'valor_promocional' => '0.00',
            'imagens' => ['https://cf.shopee.com.br/file/123456789abcdef123456789abcdef12'],
            'variacoes' => [
                [
                    'nome' => 'Cor',
                    'itens' => ['Preto', 'Branco', 'Vermelho']
                ],
                [
                    'nome' => 'Tamanho',
                    'itens' => ['P', 'M', 'G']
                ]
            ]
        ];
    } else {
        echo json_encode(['erro' => 'Tipo de importação inválido']);
        exit;
    }
    
    echo json_encode($produto);
    
} catch (Exception $e) {
    echo json_encode(['erro' => 'Erro ao processar o link: ' . $e->getMessage()]);
}